#version 330
#extension GL_EXT_gpu_shader4 : enable
//Mandelbrot test modifiedMod01.fsh  by   Sem1337
//https://www.shadertoy.com/view/fdjGDc
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define ITERS 267.
#define PI 3.1415926

vec2 rotate(vec2 v, float a) {
	float s = sin(a);
	float c = cos(a);
	mat2 m = mat2(c, -s, s, c);
	return m * v;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.y;
    vec2 frag = gl_FragCoord.xy;
    vec2 res = iResolution.xy;
    uv -= 0.5;
    //uv = abs(uv);
    //uv = rotate(uv, PI * 0.25);
    //uv = abs(uv);

    


    float tz = 0.6 - 0.45*cos(0.115*iTime);
    float zoom = pow( 0.5, 13.0*tz );

    // -0.05 , 0.6805
    vec2 c = vec2(-0.04952,.6746265) + uv * zoom;
    vec2 z;
    float r = 20.;
    float r2 = r*r;
    float iter;
    vec2 zPrev;
    for(iter = 0.; iter < ITERS ; iter++) {
        zPrev = rotate(z, iTime * 4.);
        z = vec2(z.x * z.x - z.y * z.y, 2.*z.x*z.y) + c;
        if(dot(z, zPrev) > r2) break;
    }
    float angle = atan(z.y,z.x);
    if (iter == ITERS) {
        vec3 col = vec3(0.3,0.8,0.3);
        col *= sin(length(z)*25.)*0.3 + 1.;
        gl_FragColor = vec4(col, 1.0);
        return;
    }
    float dist = length(z);
    float fracIter = (dist-r) / (r2-r);
    fracIter = log(dist) / log(r) - 1.;
    iter += (fracIter + 3.) * (fracIter + 3.);
    
    float m  = sqrt(iter / ITERS);
    vec3 col =  0.5 * cos(vec3(PI / 20. + (sin(iTime * 0.15)*0.5 + 0.5) ,0.45,0.05) * m * 100.) + 0.5;
    
    col *= vec3(smoothstep(5.,0.,fracIter));
    
    col *= 1. + sin(angle * 2.)*0.2;
    
    gl_FragColor = vec4(col, 1.0);
}